/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui.modeling;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.ui.modeling.EditingModel;
import replicatorg.app.ui.modeling.MirrorTool;
import replicatorg.app.ui.modeling.MoveTool;
import replicatorg.app.ui.modeling.PreviewPanel;
import replicatorg.app.ui.modeling.RotationTool;
import replicatorg.app.ui.modeling.ScalingTool;
import replicatorg.app.ui.modeling.Tool;
import replicatorg.app.ui.modeling.ViewTool;

public class ToolPanel
extends JPanel
implements KeyListener {
    final PreviewPanel preview;
    final JPanel subPanel = new JPanel((LayoutManager)new MigLayout("fillx,filly,ins 0, gap 0"));
    Tool[] tools = new Tool[]{new ViewTool(this), new MoveTool(this), new RotationTool(this), new MirrorTool(this), new ScalingTool(this)};
    JLabel titleLabel;
    JPanel toolControls = null;
    int ctr = 0;
    final JLabel infoLabel = new JLabel();

    public JButton createToolButton(String text, String iconPath) {
        JButton button = new JButton(text);
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        return button;
    }

    public JButton createToolButton(final Tool tool) {
        JButton button = new JButton(tool.getButtonName(), tool.getButtonIcon());
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToolPanel.this.setTool(tool);
            }
        });
        return button;
    }

    void setTool(Tool tool) {
        if (tool == null) {
            tool = this.tools[0];
        }
        this.preview.setTool(tool);
        this.titleLabel.setText(tool.getTitle());
        this.infoLabel.setText(tool.getInstructions());
        if (this.toolControls != null) {
            this.subPanel.remove(this.toolControls);
        }
        this.toolControls = tool.getControls();
        if (this.toolControls != null) {
            this.subPanel.add((Component)this.toolControls, "spanx,spany,growx,growy,width 100%");
        }
        this.validate();
        this.repaint();
    }

    EditingModel getModel() {
        return this.preview.getModel();
    }

    ToolPanel(final PreviewPanel preview) {
        this.preview = preview;
        this.setLayout((LayoutManager)new MigLayout("gap 0,filly,wrap 1"));
        JPanel toolButtons = new JPanel((LayoutManager)new MigLayout("gap 0 0,ins 0,novisualpadding,wrap 1", "0[100%]0"));
        this.add((Component)toolButtons, "south");
        int column = 0;
        int COL_COUNT = 2;
        Tool[] toolArray = this.tools;
        int n = this.tools.length;
        int n2 = 0;
        while (n2 < n) {
            Tool t = toolArray[n2];
            JButton b = this.createToolButton(t);
            if (++column == 2) {
                toolButtons.add((Component)b, "growx,growy,wrap");
                column = 0;
            } else {
                toolButtons.add((Component)b, "growx,growy");
            }
            ++n2;
        }
        JButton sliceButton = this.createToolButton("Generate GCode", "images/model-to-gcode.png");
        sliceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                preview.mainWindow.runToolpathGenerator();
            }
        });
        toolButtons.add((Component)sliceButton, "growx,spanx,wrap");
        this.titleLabel = new JLabel("Selected Tool");
        this.add((Component)this.titleLabel, "growx,gap 5,spanx,north");
        this.titleLabel.setFont(new Font("FreeSans", 1, 14));
        Font f = this.infoLabel.getFont();
        this.infoLabel.setFont(f.deriveFont((float)f.getSize() * 0.8f));
        this.add((Component)this.infoLabel, "growx,gap 2,spanx,south");
        this.add((Component)this.subPanel, "spanx,growx,growy,width 100%");
        this.setTool(this.tools[0]);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

